//**************************************************************************/
// Copyright (c) 2007 Autodesk, Inc.
// All rights reserved.
// 
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/
// DESCRIPTION: Edge detection filter effect.
// AUTHOR: Mauricio Vives
// CREATED: November 2007
//**************************************************************************/

//**************************************************************************/
// Copyright (c) 2007 Autodesk, Inc.
// All rights reserved.
// 
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/
// DESCRIPTION: Monochrome filter effect.
// AUTHOR: Mauricio Vives
// CREATED: November 2007
//**************************************************************************/

// World-view-projection transformation.
float4x4 gWVPXf : WorldViewProjection < string UIWidget = "None"; >;

// Target size.
float2 gTargetSize : ViewportPixelSize < string UIWidget = "None"; >;

// Edge color.
float4 gEdgeColor = float4(1, 0, 0, 1);

//Background color
float4 gBackgroundColor = float4(1, 1, 1, 1);

// If use the invert of the background color as the edge color.
bool gInvertColor = false;

// The single filter input, i.e. the image to be filtered.
texture gInputTex : InputTexture
<
    string UIName = "Input Texture";
> = NULL;

// Filter input sampler.
sampler2D gInputSamp = sampler_state
{
    Texture = <gInputTex>;
    MinFilter = Point;
    MagFilter = Point;
    MipFilter = Point;
};

// The edge thickness.
float gThickness 
<
    string UIName = "Thickness";
    string UIWidget = "slider";
    float UIMin = 1.0f;
    float UIMax = 5.0f;
    float UIStep = 0.5f;
> = 1.5f;

// The edge detection threshold.
float gThreshold
<
    string UIName = "Threshold";
    string UIWidget = "slider";
    float UIMin = 0.01f;
    float UIMax = 0.5f;
    float UIStep = 0.01f;
> = 0.2;

// Vertex shader input structure.
struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader output structure.
struct VS_TO_PS
{
    float4 HPos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader.
VS_TO_PS VS_FilterEdgeDetect(VS_INPUT In)
{
    VS_TO_PS Out;
    
    // Transform the position from object space to clip space for output.
    Out.HPos = mul(In.Pos, gWVPXf);
    
    // Pass the texture coordinates unchanged.
    Out.UV = In.UV;
    
    return Out;
}

// Gets the grayscale value of a color, i.e. the average of the RGB components.
float GetGray(float4 c)
{
    return dot(c.rgb, (0.33333).xxx);
}

// Pixel shader.
float4 PS_FilterEdgeDetect(VS_TO_PS In) : COLOR0
{
    float2 ox = float2(gThickness/gTargetSize.x,0.0);
    float2 oy = float2(0.0,gThickness/gTargetSize.y);
    float2 uv = In.UV.xy;
    float2 PP = uv - oy;
    float4 CC = tex2D(gInputSamp,PP-ox); float g00 = GetGray(CC);
    CC = tex2D(gInputSamp,PP);    float g01 = GetGray(CC);
    CC = tex2D(gInputSamp,PP+ox); float g02 = GetGray(CC);
    PP = uv;
    CC = tex2D(gInputSamp,PP-ox); float g10 = GetGray(CC);
    CC = tex2D(gInputSamp,PP);    float g11 = GetGray(CC);
    CC = tex2D(gInputSamp,PP+ox); float g12 = GetGray(CC);
    PP = uv + oy;
    CC = tex2D(gInputSamp,PP-ox); float g20 = GetGray(CC);
    CC = tex2D(gInputSamp,PP);    float g21 = GetGray(CC);
    CC = tex2D(gInputSamp,PP+ox); float g22 = GetGray(CC);
    float K00 = -1;
    float K01 = -2;
    float K02 = -1;
    float K10 = 0;
    float K11 = 0;
    float K12 = 0;
    float K20 = 1;
    float K21 = 2;
    float K22 = 1;
    float sx = 0;
    float sy = 0;
    sx += g00 * K00;
    sx += g01 * K01;
    sx += g02 * K02;
    sx += g10 * K10;
    sx += g11 * K11;
    sx += g12 * K12;
    sx += g20 * K20;
    sx += g21 * K21;
    sx += g22 * K22; 
    sy += g00 * K00;
    sy += g01 * K10;
    sy += g02 * K20;
    sy += g10 * K01;
    sy += g11 * K11;
    sy += g12 * K21;
    sy += g20 * K02;
    sy += g21 * K12;
    sy += g22 * K22; 
    float dist = sqrt(sx*sx+sy*sy);
    if (dist>gThreshold) { 
        if (gInvertColor)
            return float4(float3(1.0f, 1.0f, 1.0f) - gBackgroundColor.xyz, 1.0f);
        else
			return gEdgeColor; 
		}
    return gBackgroundColor;
}

// The main technique.
technique Main
{
    pass p0
    {
        VertexShader = compile vs_2_0 VS_FilterEdgeDetect();
        PixelShader = compile ps_2_0 PS_FilterEdgeDetect();
    }
}

